import { world, system, BlockTypes, BlockPermutation, ItemStack } from "@minecraft/server";

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:araucaria_fence', {
        onPlayerInteract(e) {
            const { block, player, face } = e
            const equipment = player.getComponent('equippable')
            const selectedItem = equipment.getEquipment('Mainhand')
            if (selectedItem && face === 'Up' && BlockTypes.get(selectedItem.typeId)) {
                const aboveBlock = block.above()
                if (aboveBlock.typeId === 'v360:araucaria_fence') {
                    aboveBlock.setType(selectedItem.typeId)
                    if (player.getGameMode() !== "creative") {
                        if (selectedItem.amount > 1) {
                            selectedItem.amount -= 1
                            equipment.setEquipment('Mainhand', selectedItem);
                        } else {
                            equipment.setEquipment('Mainhand', undefined)
                        }
                    }
                }
            }
        },
        onPlayerDestroy(e) {
            const { block } = e
            const aboveBlock = block.above()
            if (aboveBlock.typeId === 'v360:araucaria_fence') {
                aboveBlock.setType('minecraft:air')
            }
        },
        onTick(e) {
            const { block } = e
            const aboveBlock = block.above()
            if (block.typeId === 'v360:araucaria_fence_block' && aboveBlock.typeId === 'minecraft:air') {
                block.setType('v360:araucaria_fence')
            }
            const north = block.north()
            const east = block.east()
            const south = block.south()
            const west = block.west()
            const excludeBlocksArray = [
                'minecraft:air',
                block.hasTag('plant'),
                'minecraft:ladder',
                'minecraft:cobweb',
                'minecraft:tripwire_hook',
                'minecraft:sea_pickle',
                'minecraft:dead_bush',
                'minecraft:yellow_flower',
                'minecraft:poppy',
                'minecraft:blue_orchid',
                'minecraft:allium',
                'minecraft:azure_bluet',
                'minecraft:oxeye_daisy',
                'minecraft:sunflower',
                'minecraft:lilac',
                'minecraft:rose_bush',
                'minecraft:peony',
                'minecraft:brown_mushroom',
                'minecraft:red_mushroom',
                'minecraft:hanging_roots',
                'minecraft:glow_lichen',
                'minecraft:azalia',
                'minecraft:flowering_azalea',
                'minecraft:big_dripleaf',
                'minecraft:small_dripleaf_block',
                'minecraft:pointed_dripstone',
                'minecraft:reeds',
                'minecraft:coral',
                'minecraft:coral_fan',
                'minecraft:spore_blossom',
                'minecraft:vines',
                'minecraft:weeping_vines',
                'minecraft:twisting_vines',
                'minecraft:sweet_berry_bush',
                'minecraft:carrots',
                'minecraft:potatoes',
                'minecraft:beetroot',
                'minecraft:wheat',
                'minecraft:pumpkin_stem',
                'minecraft:melon_stem',
                'minecraft:bamboo',
                'minecraft:bamboo_sapling',
                'minecraft:moss_carpet',
                'v360:infected_moss_carpet',
                'minecraft:nether_wart',
                'minecraft:waterlily',
                'minecraft:cocoa',
                'minecraft:redstone_wire',
                'minecraft:frog_spawn',
                'minecraft:chorus_flower',
                'minecraft:chorus_plant',
                'minecraft:scaffolding',
                'minecraft:torchflower',
                'minecraft:torflower_crop',
                'minecraft:unlit_redstone_torch',
                'minecraft:pitcher_plant',
                'minecraft:pitcher_crop',
                'minecraft:farmland',
                'minecraft:grass_path',
                'minecraft:nether_sprouts',
                'minecraft:crimson_roots',
                'minecraft:acacia_leaves',
                'minecraft:azalea_leaves',
                'minecraft:birch_leaves',
                'minecraft:cherry_leaves',
                'minecraft:dark_oak_leaves',
                'minecraft:flowering_azalea_leaves',
                'minecraft:jungle_leaves',
                'minecraft:mangrove_leaves',
                'minecraft:oak_leaves',
                'minecraft:spruce_leaves',
                'minecraft:orange_carpet',
                'minecraft:magenta_carpet',
                'minecraft:light_blue_carpet',
                'minecraft:yellow_carpet',
                'minecraft:lime_carpet',
                'minecraft:pink_carpet',
                'minecraft:gray_carpet',
                'minecraft:light_gray_carpet',
                'minecraft:cyan_carpet',
                'minecraft:purple_carpet',
                'minecraft:blue_carpet',
                'minecraft:brown_carpet',
                'minecraft:green_carpet',
                'minecraft:red_carpet',
                'minecraft:black_carpet',
                'minecraft:observer',
                'minecraft:amethyst_cluster',
                'minecraft:acacia_door',
                'minecraft:birch_door',
                'minecraft:dark_oak_door',
                'minecraft:iron_door',
                'minecraft:jungle_door',
                'minecraft:oak_door',
                'minecraft:spruce_door',
                'minecraft:bamboo_door',
                'minecraft:cherry_door',
                'minecraft:copper_door',
                'minecraft:exposed_copper_door',
                'minecraft:weathered_copper_door',
                'minecraft:oxidized_copper_door',
                'minecraft:waxed_copper_door',
                'minecraft:waxed_exposed_copper_door',
                'minecraft:waxed_weathered_copper_door',
                'minecraft:waxed_oxidized_copper_door',
                'minecraft:torch',
                'minecraft:soul_torch',
                'minecraft:lantern',
                'minecraft:soul_lantern',
                'minecraft:acacia_sign',
                'minecraft:birch_sign',
                'minecraft:dark_oak_sign',
                'minecraft:jungle_sign',
                'minecraft:oak_sign',
                'minecraft:spruce_sign',
                'minecraft:mangrove_sign',
                'minecraft:crimson_sign',
                'minecraft:warped_sign',
                'minecraft:bamboo_sign',
                'minecraft:cherry_sign',
                'minecraft:acacia_wall_sign',
                'minecraft:birch_wall_sign',
                'minecraft:dark_oak_wall_sign',
                'minecraft:jungle_wall_sign',
                'minecraft:oak_wall_sign',
                'minecraft:spruce_wall_sign',
                'minecraft:mangrove_wall_sign',
                'minecraft:crimson_wall_sign',
                'minecraft:warped_wall_sign',
                'minecraft:bamboo_wall_sign',
                'minecraft:cherry_wall_sign',
                'minecraft:oak_hanging_sign',
                'minecraft:spruce_hanging_sign',
                'minecraft:birch_hanging_sign',
                'minecraft:jungle_hanging_sign',
                'minecraft:acacia_hanging_sign',
                'minecraft:dark_oak_hanging_sign',
                'minecraft:mangrove_hanging_sign',
                'minecraft:crimson_hanging_sign',
                'minecraft:warped_hanging_sign',
                'minecraft:bamboo_hanging_sign',
                'minecraft:cherry_hanging_sign',
                'minecraft:glass_pane',
                'minecraft:iron_bars',
                'minecraft:barrel',
                'minecraft:chest',
                'minecraft:ender_chest',
                'minecraft:trapped_chest',
                'minecraft:dragon_egg',
                'minecraft:white_banner',
                'minecraft:orange_banner',
                'minecraft:magenta_banner',
                'minecraft:light_blue_banner',
                'minecraft:yellow_banner',
                'minecraft:lime_banner',
                'minecraft:pink_banner',
                'minecraft:gray_banner',
                'minecraft:light_gray_banner',
                'minecraft:cyan_banner',
                'minecraft:purple_banner',
                'minecraft:blue_banner',
                'minecraft:brown_banner',
                'minecraft:green_banner',
                'minecraft:red_banner',
                'minecraft:black_banner',
                'minecraft:acacia_trapdoor',
                'minecraft:birch_trapdoor',
                'minecraft:dark_oak_trapdoor',
                'minecraft:iron_trapdoor',
                'minecraft:jungle_trapdoor',
                'minecraft:oak_trapdoor',
                'minecraft:spruce_trapdoor',
                'minecraft:acacia_trapdoor',
                'minecraft:bamboo_trapdoor',
                'minecraft:cherry_trapaoor',
                'minecraft:copper_trapdoor',
                'minecraft:exposed_copper_trapdoor',
                'minecraft:weathered_copper_trapdoor',
                'minecraft:oxidized_copper_trapdoor',
                'minecraft:waxed_copper_trapdoor',
                'minecraft:waxed_exposed_copper_trapdoor',
                'minecraft:waxed_weathered_copper_trapdoor',
                'minecraft:waxed_oxidized_copper_trapdoor',
                'minecraft:cobblestone_wall',
                'minecraft:mossy_cobblestone_wall',
                'minecraft:brick_wall',
                'minecraft:prismarine_wall',
                'minecraft:red_sandstone_wall',
                'minecraft:mossy_stone_brick_wall',
                'minecraft:granite_wall',
                'minecraft:stone_brick_wall',
                'minecraft:nether_brick_wall',
                'minecraft:andesite_wall',
                'minecraft:red_nether_brick_wall',
                'minecraft:sandstone_wall',
                'minecraft:end_stone_brick_wall',
                'minecraft:diorite_wall',
                'minecraft:blackstone_wall',
                'minecraft:polished_blackstone_wall',
                'minecraft:polished_blackstone_brick_wall',
                'minecraft:copper_wall',
                'minecraft:bed',
                'minecraft:white_bed',
                'minecraft:orange_bed',
                'minecraft:magenta_bed',
                'minecraft:light_blue_bed',
                'minecraft:yellow_bed',
                'minecraft:lime_bed',
                'minecraft:pink_bed',
                'minecraft:gray_bed',
                'minecraft:light_gray_bed',
                'minecraft:cyan_bed',
                'minecraft:purple_bed',
                'minecraft:blue_bed',
                'minecraft:brown_bed',
                'minecraft:green_bed',
                'minecraft:red_bed',
                'minecraft:black_bed',
                'minecraft:candle',
                'minecraft:white_candle',
                'minecraft:orange_candle',
                'minecraft:magenta_candle',
                'minecraft:light_blue_candle',
                'minecraft:yellow_candle',
                'minecraft:lime_candle',
                'minecraft:pink_candle',
                'minecraft:gray_candle',
                'minecraft:light_gray_candle',
                'minecraft:cyan_candle',
                'minecraft:purple_candle',
                'minecraft:blue_candle',
                'minecraft:brown_candle',
                'minecraft:green_candle',
                'minecraft:red_candle',
                'minecraft:black_candle',
                'minecraft:campfire',
                'minecraft:soul_campfire',
                'minecraft:anvil',
                'minecraft:chipped_anvil',
                'minecraft:damaged_anvil',
                'minecraft:coral_fan',
                'minecraft:dead_coral_fan',
                'minecraft:fire_coral_fan',
                'minecraft:horn_coral_fan',
                'minecraft:bubble_coral_fan',
                'minecraft:tube_coral_fan',
                'minecraft:brain_coral_fan',
                'minecraft:acacia_sapling',
                'minecraft:birch_sapling',
                'minecraft:dark_oak_sapling',
                'minecraft:jungle_sapling',
                'minecraft:oak_sapling',
                'minecraft:spruce_sapling',
                'minecraft:red_tulip',
                'minecraft:orange_tulip',
                'minecraft:white_tulip',
                'minecraft:pink_tulip',
                'minecraft:acacia_slab',
                'minecraft:birch_slab',
                'minecraft:dark_oak_slab',
                'minecraft:jungle_slab',
                'minecraft:oak_slab',
                'minecraft:spruce_slab',
                'minecraft:mangrove_slab',
                'minecraft:crimson_slab',
                'minecraft:warped_slab',
                'minecraft:bamboo_slab',
                'minecraft:cherry_slab',
                'minecraft:stone_slab',
                'minecraft:smooth_stone_slab',
                'minecraft:sandstone_slab',
                'minecraft:cut_sandstone_slab',
                'minecraft:petrified_oak_slab',
                'minecraft:cobblestone_slab',
                'minecraft:brick_slab',
                'minecraft:stone_brick_slab',
                'minecraft:nether_brick_slab',
                'minecraft:quartz_slab',
                'minecraft:red_sandstone_slab',
                'minecraft:cut_red_sandstone_slab',
                'minecraft:purpur_slab',
                'minecraft:prismarine_slab',
                'minecraft:prismarine_brick_slab',
                'minecraft:dark_prismarine_slab',
                'minecraft:smooth_quartz_slab',
                'minecraft:smooth_red_sandstone_slab',
                'minecraft:smooth_sandstone_slab',
                'minecraft:end_stone_brick_slab',
                'minecraft:andesite_slab',
                'minecraft:polished_andesite_slab',
                'minecraft:diorite_slab',
                'minecraft:polished_diorite_slab',
                'minecraft:granite_slab',
                'minecraft:polished_granite_slab',
                'minecraft:mossy_stone_brick_slab',
                'minecraft:mossy_cobblestone_slab',
                'minecraft:red_nether_brick_slab',
                'minecraft:blackstone_slab',
                'minecraft:polished_blackstone_slab',
                'minecraft:polished_blackstone_brick_slab',
                'minecraft:deepslate_slab',
                'minecraft:cobbled_deepslate_slab',
                'minecraft:polished_deepslate_slab',
                'minecraft:deepslate_brick_slab',
                'minecraft:deepslate_tile_slab',
                'minecraft:cut_copper_slab',
                'minecraft:exposed_cut_copper_slab',
                'minecraft:weathered_cut_copper_slab',
                'minecraft:oxidized_cut_copper_slab',
                'minecraft:waxed_cut_copper_slab',
                'minecraft:waxed_exposed_cut_copper_slab',
                'minecraft:waxed_weathered_cut_copper_slab',
                'minecraft:waxed_oxidized_cut_copper_slab',
                'minecraft:pot',
                'minecraft:decorated_pot',
                'minecraft:item_frame',
                'minecraft:glow_item_frame',
                'minecraft:button',
                'minecraft:acacia_button',
                'minecraft:birch_button',
                'minecraft:dark_oak_button',
                'minecraft:jungle_button',
                'minecraft:oak_button',
                'minecraft:spruce_button',
                'minecraft:stone_button',
                'minecraft:pressure_plate',
                'minecraft:acacia_pressure_plate',
                'minecraft:birch_pressure_plate',
                'minecraft:dark_oak_pressure_plate',
                'minecraft:heavy_weighted_pressure_plate',
                'minecraft:jungle_pressure_plate',
                'minecraft:light_weighted_pressure_plate',
                'minecraft:oak_pressure_plate',
                'minecraft:spruce_pressure_plate',
                'minecraft:stone_pressure_plate',
                'minecraft:rail',
                'minecraft:detector_rail',
                'minecraft:activator_rail',
                'minecraft:powered_rail'
            ]
            const northConnects = !excludeBlocksArray.includes(north?.typeId)
            const eastConnects = !excludeBlocksArray.includes(east?.typeId)
            const southConnects = !excludeBlocksArray.includes(south?.typeId)
            const westConnects = !excludeBlocksArray.includes(west?.typeId)
            block.setPermutation(block.permutation.withState('v360:north_picket', northConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:south_picket', southConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:east_picket', eastConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:west_picket', westConnects ? 1 : 0))
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:araucaria_fence_tick', {
        onTick(e) {
            const { block } = e
            const aboveBlock = block.above()
            if (block.typeId === 'v360:araucaria_fence_block' && aboveBlock.typeId === 'minecraft:air') {
                block.setType('v360:araucaria_fence')
            }
            const north = block.north()
            const east = block.east()
            const south = block.south()
            const west = block.west()
            const excludeBlocksArray = [
                'minecraft:air',
                block.hasTag('plant'),
                'minecraft:ladder',
                'minecraft:cobweb',
                'minecraft:tripwire_hook',
                'minecraft:sea_pickle',
                'minecraft:dead_bush',
                'minecraft:yellow_flower',
                'minecraft:poppy',
                'minecraft:blue_orchid',
                'minecraft:allium',
                'minecraft:azure_bluet',
                'minecraft:oxeye_daisy',
                'minecraft:sunflower',
                'minecraft:lilac',
                'minecraft:rose_bush',
                'minecraft:peony',
                'minecraft:brown_mushroom',
                'minecraft:red_mushroom',
                'minecraft:hanging_roots',
                'minecraft:glow_lichen',
                'minecraft:azalia',
                'minecraft:flowering_azalea',
                'minecraft:big_dripleaf',
                'minecraft:small_dripleaf_block',
                'minecraft:pointed_dripstone',
                'minecraft:reeds',
                'minecraft:coral',
                'minecraft:coral_fan',
                'minecraft:spore_blossom',
                'minecraft:vines',
                'minecraft:weeping_vines',
                'minecraft:twisting_vines',
                'minecraft:sweet_berry_bush',
                'minecraft:carrots',
                'minecraft:potatoes',
                'minecraft:beetroot',
                'minecraft:wheat',
                'minecraft:pumpkin_stem',
                'minecraft:melon_stem',
                'minecraft:bamboo',
                'minecraft:bamboo_sapling',
                'minecraft:moss_carpet',
                'v360:infected_moss_carpet',
                'minecraft:nether_wart',
                'minecraft:waterlily',
                'minecraft:cocoa',
                'minecraft:redstone_wire',
                'minecraft:frog_spawn',
                'minecraft:chorus_flower',
                'minecraft:chorus_plant',
                'minecraft:scaffolding',
                'minecraft:torchflower',
                'minecraft:torflower_crop',
                'minecraft:unlit_redstone_torch',
                'minecraft:pitcher_plant',
                'minecraft:pitcher_crop',
                'minecraft:farmland',
                'minecraft:grass_path',
                'minecraft:nether_sprouts',
                'minecraft:crimson_roots',
                'minecraft:acacia_leaves',
                'minecraft:azalea_leaves',
                'minecraft:birch_leaves',
                'minecraft:cherry_leaves',
                'minecraft:dark_oak_leaves',
                'minecraft:flowering_azalea_leaves',
                'minecraft:jungle_leaves',
                'minecraft:mangrove_leaves',
                'minecraft:oak_leaves',
                'minecraft:spruce_leaves',
                'minecraft:orange_carpet',
                'minecraft:magenta_carpet',
                'minecraft:light_blue_carpet',
                'minecraft:yellow_carpet',
                'minecraft:lime_carpet',
                'minecraft:pink_carpet',
                'minecraft:gray_carpet',
                'minecraft:light_gray_carpet',
                'minecraft:cyan_carpet',
                'minecraft:purple_carpet',
                'minecraft:blue_carpet',
                'minecraft:brown_carpet',
                'minecraft:green_carpet',
                'minecraft:red_carpet',
                'minecraft:black_carpet',
                'minecraft:observer',
                'minecraft:amethyst_cluster',
                'minecraft:acacia_door',
                'minecraft:birch_door',
                'minecraft:dark_oak_door',
                'minecraft:iron_door',
                'minecraft:jungle_door',
                'minecraft:oak_door',
                'minecraft:spruce_door',
                'minecraft:bamboo_door',
                'minecraft:cherry_door',
                'minecraft:copper_door',
                'minecraft:exposed_copper_door',
                'minecraft:weathered_copper_door',
                'minecraft:oxidized_copper_door',
                'minecraft:waxed_copper_door',
                'minecraft:waxed_exposed_copper_door',
                'minecraft:waxed_weathered_copper_door',
                'minecraft:waxed_oxidized_copper_door',
                'minecraft:torch',
                'minecraft:soul_torch',
                'minecraft:lantern',
                'minecraft:soul_lantern',
                'minecraft:acacia_sign',
                'minecraft:birch_sign',
                'minecraft:dark_oak_sign',
                'minecraft:jungle_sign',
                'minecraft:oak_sign',
                'minecraft:spruce_sign',
                'minecraft:mangrove_sign',
                'minecraft:crimson_sign',
                'minecraft:warped_sign',
                'minecraft:bamboo_sign',
                'minecraft:cherry_sign',
                'minecraft:acacia_wall_sign',
                'minecraft:birch_wall_sign',
                'minecraft:dark_oak_wall_sign',
                'minecraft:jungle_wall_sign',
                'minecraft:oak_wall_sign',
                'minecraft:spruce_wall_sign',
                'minecraft:mangrove_wall_sign',
                'minecraft:crimson_wall_sign',
                'minecraft:warped_wall_sign',
                'minecraft:bamboo_wall_sign',
                'minecraft:cherry_wall_sign',
                'minecraft:oak_hanging_sign',
                'minecraft:spruce_hanging_sign',
                'minecraft:birch_hanging_sign',
                'minecraft:jungle_hanging_sign',
                'minecraft:acacia_hanging_sign',
                'minecraft:dark_oak_hanging_sign',
                'minecraft:mangrove_hanging_sign',
                'minecraft:crimson_hanging_sign',
                'minecraft:warped_hanging_sign',
                'minecraft:bamboo_hanging_sign',
                'minecraft:cherry_hanging_sign',
                'minecraft:glass_pane',
                'minecraft:iron_bars',
                'minecraft:barrel',
                'minecraft:chest',
                'minecraft:ender_chest',
                'minecraft:trapped_chest',
                'minecraft:dragon_egg',
                'minecraft:white_banner',
                'minecraft:orange_banner',
                'minecraft:magenta_banner',
                'minecraft:light_blue_banner',
                'minecraft:yellow_banner',
                'minecraft:lime_banner',
                'minecraft:pink_banner',
                'minecraft:gray_banner',
                'minecraft:light_gray_banner',
                'minecraft:cyan_banner',
                'minecraft:purple_banner',
                'minecraft:blue_banner',
                'minecraft:brown_banner',
                'minecraft:green_banner',
                'minecraft:red_banner',
                'minecraft:black_banner',
                'minecraft:acacia_trapdoor',
                'minecraft:birch_trapdoor',
                'minecraft:dark_oak_trapdoor',
                'minecraft:iron_trapdoor',
                'minecraft:jungle_trapdoor',
                'minecraft:oak_trapdoor',
                'minecraft:spruce_trapdoor',
                'minecraft:acacia_trapdoor',
                'minecraft:bamboo_trapdoor',
                'minecraft:cherry_trapaoor',
                'minecraft:copper_trapdoor',
                'minecraft:exposed_copper_trapdoor',
                'minecraft:weathered_copper_trapdoor',
                'minecraft:oxidized_copper_trapdoor',
                'minecraft:waxed_copper_trapdoor',
                'minecraft:waxed_exposed_copper_trapdoor',
                'minecraft:waxed_weathered_copper_trapdoor',
                'minecraft:waxed_oxidized_copper_trapdoor',
                'minecraft:cobblestone_wall',
                'minecraft:mossy_cobblestone_wall',
                'minecraft:brick_wall',
                'minecraft:prismarine_wall',
                'minecraft:red_sandstone_wall',
                'minecraft:mossy_stone_brick_wall',
                'minecraft:granite_wall',
                'minecraft:stone_brick_wall',
                'minecraft:nether_brick_wall',
                'minecraft:andesite_wall',
                'minecraft:red_nether_brick_wall',
                'minecraft:sandstone_wall',
                'minecraft:end_stone_brick_wall',
                'minecraft:diorite_wall',
                'minecraft:blackstone_wall',
                'minecraft:polished_blackstone_wall',
                'minecraft:polished_blackstone_brick_wall',
                'minecraft:copper_wall',
                'minecraft:bed',
                'minecraft:white_bed',
                'minecraft:orange_bed',
                'minecraft:magenta_bed',
                'minecraft:light_blue_bed',
                'minecraft:yellow_bed',
                'minecraft:lime_bed',
                'minecraft:pink_bed',
                'minecraft:gray_bed',
                'minecraft:light_gray_bed',
                'minecraft:cyan_bed',
                'minecraft:purple_bed',
                'minecraft:blue_bed',
                'minecraft:brown_bed',
                'minecraft:green_bed',
                'minecraft:red_bed',
                'minecraft:black_bed',
                'minecraft:candle',
                'minecraft:white_candle',
                'minecraft:orange_candle',
                'minecraft:magenta_candle',
                'minecraft:light_blue_candle',
                'minecraft:yellow_candle',
                'minecraft:lime_candle',
                'minecraft:pink_candle',
                'minecraft:gray_candle',
                'minecraft:light_gray_candle',
                'minecraft:cyan_candle',
                'minecraft:purple_candle',
                'minecraft:blue_candle',
                'minecraft:brown_candle',
                'minecraft:green_candle',
                'minecraft:red_candle',
                'minecraft:black_candle',
                'minecraft:campfire',
                'minecraft:soul_campfire',
                'minecraft:anvil',
                'minecraft:chipped_anvil',
                'minecraft:damaged_anvil',
                'minecraft:coral_fan',
                'minecraft:dead_coral_fan',
                'minecraft:fire_coral_fan',
                'minecraft:horn_coral_fan',
                'minecraft:bubble_coral_fan',
                'minecraft:tube_coral_fan',
                'minecraft:brain_coral_fan',
                'minecraft:acacia_sapling',
                'minecraft:birch_sapling',
                'minecraft:dark_oak_sapling',
                'minecraft:jungle_sapling',
                'minecraft:oak_sapling',
                'minecraft:spruce_sapling',
                'minecraft:red_tulip',
                'minecraft:orange_tulip',
                'minecraft:white_tulip',
                'minecraft:pink_tulip',
                'minecraft:acacia_slab',
                'minecraft:birch_slab',
                'minecraft:dark_oak_slab',
                'minecraft:jungle_slab',
                'minecraft:oak_slab',
                'minecraft:spruce_slab',
                'minecraft:mangrove_slab',
                'minecraft:crimson_slab',
                'minecraft:warped_slab',
                'minecraft:bamboo_slab',
                'minecraft:cherry_slab',
                'minecraft:stone_slab',
                'minecraft:smooth_stone_slab',
                'minecraft:sandstone_slab',
                'minecraft:cut_sandstone_slab',
                'minecraft:petrified_oak_slab',
                'minecraft:cobblestone_slab',
                'minecraft:brick_slab',
                'minecraft:stone_brick_slab',
                'minecraft:nether_brick_slab',
                'minecraft:quartz_slab',
                'minecraft:red_sandstone_slab',
                'minecraft:cut_red_sandstone_slab',
                'minecraft:purpur_slab',
                'minecraft:prismarine_slab',
                'minecraft:prismarine_brick_slab',
                'minecraft:dark_prismarine_slab',
                'minecraft:smooth_quartz_slab',
                'minecraft:smooth_red_sandstone_slab',
                'minecraft:smooth_sandstone_slab',
                'minecraft:end_stone_brick_slab',
                'minecraft:andesite_slab',
                'minecraft:polished_andesite_slab',
                'minecraft:diorite_slab',
                'minecraft:polished_diorite_slab',
                'minecraft:granite_slab',
                'minecraft:polished_granite_slab',
                'minecraft:mossy_stone_brick_slab',
                'minecraft:mossy_cobblestone_slab',
                'minecraft:red_nether_brick_slab',
                'minecraft:blackstone_slab',
                'minecraft:polished_blackstone_slab',
                'minecraft:polished_blackstone_brick_slab',
                'minecraft:deepslate_slab',
                'minecraft:cobbled_deepslate_slab',
                'minecraft:polished_deepslate_slab',
                'minecraft:deepslate_brick_slab',
                'minecraft:deepslate_tile_slab',
                'minecraft:cut_copper_slab',
                'minecraft:exposed_cut_copper_slab',
                'minecraft:weathered_cut_copper_slab',
                'minecraft:oxidized_cut_copper_slab',
                'minecraft:waxed_cut_copper_slab',
                'minecraft:waxed_exposed_cut_copper_slab',
                'minecraft:waxed_weathered_cut_copper_slab',
                'minecraft:waxed_oxidized_cut_copper_slab',
                'minecraft:pot',
                'minecraft:decorated_pot',
                'minecraft:item_frame',
                'minecraft:glow_item_frame',
                'minecraft:button',
                'minecraft:acacia_button',
                'minecraft:birch_button',
                'minecraft:dark_oak_button',
                'minecraft:jungle_button',
                'minecraft:oak_button',
                'minecraft:spruce_button',
                'minecraft:stone_button',
                'minecraft:pressure_plate',
                'minecraft:acacia_pressure_plate',
                'minecraft:birch_pressure_plate',
                'minecraft:dark_oak_pressure_plate',
                'minecraft:heavy_weighted_pressure_plate',
                'minecraft:jungle_pressure_plate',
                'minecraft:light_weighted_pressure_plate',
                'minecraft:oak_pressure_plate',
                'minecraft:spruce_pressure_plate',
                'minecraft:stone_pressure_plate',
                'minecraft:rail',
                'minecraft:detector_rail',
                'minecraft:activator_rail',
                'minecraft:powered_rail'
            ]
            const northConnects = !excludeBlocksArray.includes(north?.typeId)
            const eastConnects = !excludeBlocksArray.includes(east?.typeId)
            const southConnects = !excludeBlocksArray.includes(south?.typeId)
            const westConnects = !excludeBlocksArray.includes(west?.typeId)
            block.setPermutation(block.permutation.withState('v360:north_picket', northConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:south_picket', southConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:east_picket', eastConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:west_picket', westConnects ? 1 : 0))
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:araucaria_fence_place', {
        onPlace(e) {
            const { block } = e
            const aboveBlock = block.above()
            e.block.setType('v360:araucaria_fence_block')
            if (aboveBlock.typeId === 'minecraft:air') {
                aboveBlock.setPermutation(BlockPermutation.resolve('v360:araucaria_fence', { 'v360:post': 1 }))
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:end_fence', {
        onPlayerInteract(e) {
            const { block, player, face } = e
            const equipment = player.getComponent('equippable')
            const selectedItem = equipment.getEquipment('Mainhand')
            if (selectedItem && face === 'Up' && BlockTypes.get(selectedItem.typeId)) {
                const aboveBlock = block.above()
                if (aboveBlock.typeId === 'v360:end_fence') {
                    aboveBlock.setType(selectedItem.typeId)
                    if (player.getGameMode() !== "creative") {
                        if (selectedItem.amount > 1) {
                            selectedItem.amount -= 1
                            equipment.setEquipment('Mainhand', selectedItem);
                        } else {
                            equipment.setEquipment('Mainhand', undefined)
                        }
                    }
                }
            }
        },
        onPlayerDestroy(e) {
            const { block } = e
            const aboveBlock = block.above()
            if (aboveBlock.typeId === 'v360:end_fence') {
                aboveBlock.setType('minecraft:air')
            }
        },
        onTick(e) {
            const { block } = e
            const aboveBlock = block.above()
            if (block.typeId === 'v360:end_fence_block' && aboveBlock.typeId === 'minecraft:air') {
                block.setType('v360:end_fence')
            }
            const north = block.north()
            const east = block.east()
            const south = block.south()
            const west = block.west()
            const excludeBlocksArray = [
                'minecraft:air',
                block.hasTag('plant'),
                'minecraft:ladder',
                'minecraft:cobweb',
                'minecraft:tripwire_hook',
                'minecraft:sea_pickle',
                'minecraft:dead_bush',
                'minecraft:yellow_flower',
                'minecraft:poppy',
                'minecraft:blue_orchid',
                'minecraft:allium',
                'minecraft:azure_bluet',
                'minecraft:oxeye_daisy',
                'minecraft:sunflower',
                'minecraft:lilac',
                'minecraft:rose_bush',
                'minecraft:peony',
                'minecraft:brown_mushroom',
                'minecraft:red_mushroom',
                'minecraft:hanging_roots',
                'minecraft:glow_lichen',
                'minecraft:azalia',
                'minecraft:flowering_azalea',
                'minecraft:big_dripleaf',
                'minecraft:small_dripleaf_block',
                'minecraft:pointed_dripstone',
                'minecraft:reeds',
                'minecraft:coral',
                'minecraft:coral_fan',
                'minecraft:spore_blossom',
                'minecraft:vines',
                'minecraft:weeping_vines',
                'minecraft:twisting_vines',
                'minecraft:sweet_berry_bush',
                'minecraft:carrots',
                'minecraft:potatoes',
                'minecraft:beetroot',
                'minecraft:wheat',
                'minecraft:pumpkin_stem',
                'minecraft:melon_stem',
                'minecraft:bamboo',
                'minecraft:bamboo_sapling',
                'minecraft:moss_carpet',
                'v360:infected_moss_carpet',
                'minecraft:nether_wart',
                'minecraft:waterlily',
                'minecraft:cocoa',
                'minecraft:redstone_wire',
                'minecraft:frog_spawn',
                'minecraft:chorus_flower',
                'minecraft:chorus_plant',
                'minecraft:scaffolding',
                'minecraft:torchflower',
                'minecraft:torflower_crop',
                'minecraft:unlit_redstone_torch',
                'minecraft:pitcher_plant',
                'minecraft:pitcher_crop',
                'minecraft:farmland',
                'minecraft:grass_path',
                'minecraft:nether_sprouts',
                'minecraft:crimson_roots',
                'minecraft:acacia_leaves',
                'minecraft:azalea_leaves',
                'minecraft:birch_leaves',
                'minecraft:cherry_leaves',
                'minecraft:dark_oak_leaves',
                'minecraft:flowering_azalea_leaves',
                'minecraft:jungle_leaves',
                'minecraft:mangrove_leaves',
                'minecraft:oak_leaves',
                'minecraft:spruce_leaves',
                'minecraft:orange_carpet',
                'minecraft:magenta_carpet',
                'minecraft:light_blue_carpet',
                'minecraft:yellow_carpet',
                'minecraft:lime_carpet',
                'minecraft:pink_carpet',
                'minecraft:gray_carpet',
                'minecraft:light_gray_carpet',
                'minecraft:cyan_carpet',
                'minecraft:purple_carpet',
                'minecraft:blue_carpet',
                'minecraft:brown_carpet',
                'minecraft:green_carpet',
                'minecraft:red_carpet',
                'minecraft:black_carpet',
                'minecraft:observer',
                'minecraft:amethyst_cluster',
                'minecraft:acacia_door',
                'minecraft:birch_door',
                'minecraft:dark_oak_door',
                'minecraft:iron_door',
                'minecraft:jungle_door',
                'minecraft:oak_door',
                'minecraft:spruce_door',
                'minecraft:bamboo_door',
                'minecraft:cherry_door',
                'minecraft:copper_door',
                'minecraft:exposed_copper_door',
                'minecraft:weathered_copper_door',
                'minecraft:oxidized_copper_door',
                'minecraft:waxed_copper_door',
                'minecraft:waxed_exposed_copper_door',
                'minecraft:waxed_weathered_copper_door',
                'minecraft:waxed_oxidized_copper_door',
                'minecraft:torch',
                'minecraft:soul_torch',
                'minecraft:lantern',
                'minecraft:soul_lantern',
                'minecraft:acacia_sign',
                'minecraft:birch_sign',
                'minecraft:dark_oak_sign',
                'minecraft:jungle_sign',
                'minecraft:oak_sign',
                'minecraft:spruce_sign',
                'minecraft:mangrove_sign',
                'minecraft:crimson_sign',
                'minecraft:warped_sign',
                'minecraft:bamboo_sign',
                'minecraft:cherry_sign',
                'minecraft:acacia_wall_sign',
                'minecraft:birch_wall_sign',
                'minecraft:dark_oak_wall_sign',
                'minecraft:jungle_wall_sign',
                'minecraft:oak_wall_sign',
                'minecraft:spruce_wall_sign',
                'minecraft:mangrove_wall_sign',
                'minecraft:crimson_wall_sign',
                'minecraft:warped_wall_sign',
                'minecraft:bamboo_wall_sign',
                'minecraft:cherry_wall_sign',
                'minecraft:oak_hanging_sign',
                'minecraft:spruce_hanging_sign',
                'minecraft:birch_hanging_sign',
                'minecraft:jungle_hanging_sign',
                'minecraft:acacia_hanging_sign',
                'minecraft:dark_oak_hanging_sign',
                'minecraft:mangrove_hanging_sign',
                'minecraft:crimson_hanging_sign',
                'minecraft:warped_hanging_sign',
                'minecraft:bamboo_hanging_sign',
                'minecraft:cherry_hanging_sign',
                'minecraft:glass_pane',
                'minecraft:iron_bars',
                'minecraft:barrel',
                'minecraft:chest',
                'minecraft:ender_chest',
                'minecraft:trapped_chest',
                'minecraft:dragon_egg',
                'minecraft:white_banner',
                'minecraft:orange_banner',
                'minecraft:magenta_banner',
                'minecraft:light_blue_banner',
                'minecraft:yellow_banner',
                'minecraft:lime_banner',
                'minecraft:pink_banner',
                'minecraft:gray_banner',
                'minecraft:light_gray_banner',
                'minecraft:cyan_banner',
                'minecraft:purple_banner',
                'minecraft:blue_banner',
                'minecraft:brown_banner',
                'minecraft:green_banner',
                'minecraft:red_banner',
                'minecraft:black_banner',
                'minecraft:acacia_trapdoor',
                'minecraft:birch_trapdoor',
                'minecraft:dark_oak_trapdoor',
                'minecraft:iron_trapdoor',
                'minecraft:jungle_trapdoor',
                'minecraft:oak_trapdoor',
                'minecraft:spruce_trapdoor',
                'minecraft:acacia_trapdoor',
                'minecraft:bamboo_trapdoor',
                'minecraft:cherry_trapaoor',
                'minecraft:copper_trapdoor',
                'minecraft:exposed_copper_trapdoor',
                'minecraft:weathered_copper_trapdoor',
                'minecraft:oxidized_copper_trapdoor',
                'minecraft:waxed_copper_trapdoor',
                'minecraft:waxed_exposed_copper_trapdoor',
                'minecraft:waxed_weathered_copper_trapdoor',
                'minecraft:waxed_oxidized_copper_trapdoor',
                'minecraft:cobblestone_wall',
                'minecraft:mossy_cobblestone_wall',
                'minecraft:brick_wall',
                'minecraft:prismarine_wall',
                'minecraft:red_sandstone_wall',
                'minecraft:mossy_stone_brick_wall',
                'minecraft:granite_wall',
                'minecraft:stone_brick_wall',
                'minecraft:nether_brick_wall',
                'minecraft:andesite_wall',
                'minecraft:red_nether_brick_wall',
                'minecraft:sandstone_wall',
                'minecraft:end_stone_brick_wall',
                'minecraft:diorite_wall',
                'minecraft:blackstone_wall',
                'minecraft:polished_blackstone_wall',
                'minecraft:polished_blackstone_brick_wall',
                'minecraft:copper_wall',
                'minecraft:bed',
                'minecraft:white_bed',
                'minecraft:orange_bed',
                'minecraft:magenta_bed',
                'minecraft:light_blue_bed',
                'minecraft:yellow_bed',
                'minecraft:lime_bed',
                'minecraft:pink_bed',
                'minecraft:gray_bed',
                'minecraft:light_gray_bed',
                'minecraft:cyan_bed',
                'minecraft:purple_bed',
                'minecraft:blue_bed',
                'minecraft:brown_bed',
                'minecraft:green_bed',
                'minecraft:red_bed',
                'minecraft:black_bed',
                'minecraft:candle',
                'minecraft:white_candle',
                'minecraft:orange_candle',
                'minecraft:magenta_candle',
                'minecraft:light_blue_candle',
                'minecraft:yellow_candle',
                'minecraft:lime_candle',
                'minecraft:pink_candle',
                'minecraft:gray_candle',
                'minecraft:light_gray_candle',
                'minecraft:cyan_candle',
                'minecraft:purple_candle',
                'minecraft:blue_candle',
                'minecraft:brown_candle',
                'minecraft:green_candle',
                'minecraft:red_candle',
                'minecraft:black_candle',
                'minecraft:campfire',
                'minecraft:soul_campfire',
                'minecraft:anvil',
                'minecraft:chipped_anvil',
                'minecraft:damaged_anvil',
                'minecraft:coral_fan',
                'minecraft:dead_coral_fan',
                'minecraft:fire_coral_fan',
                'minecraft:horn_coral_fan',
                'minecraft:bubble_coral_fan',
                'minecraft:tube_coral_fan',
                'minecraft:brain_coral_fan',
                'minecraft:acacia_sapling',
                'minecraft:birch_sapling',
                'minecraft:dark_oak_sapling',
                'minecraft:jungle_sapling',
                'minecraft:oak_sapling',
                'minecraft:spruce_sapling',
                'minecraft:red_tulip',
                'minecraft:orange_tulip',
                'minecraft:white_tulip',
                'minecraft:pink_tulip',
                'minecraft:acacia_slab',
                'minecraft:birch_slab',
                'minecraft:dark_oak_slab',
                'minecraft:jungle_slab',
                'minecraft:oak_slab',
                'minecraft:spruce_slab',
                'minecraft:mangrove_slab',
                'minecraft:crimson_slab',
                'minecraft:warped_slab',
                'minecraft:bamboo_slab',
                'minecraft:cherry_slab',
                'minecraft:stone_slab',
                'minecraft:smooth_stone_slab',
                'minecraft:sandstone_slab',
                'minecraft:cut_sandstone_slab',
                'minecraft:petrified_oak_slab',
                'minecraft:cobblestone_slab',
                'minecraft:brick_slab',
                'minecraft:stone_brick_slab',
                'minecraft:nether_brick_slab',
                'minecraft:quartz_slab',
                'minecraft:red_sandstone_slab',
                'minecraft:cut_red_sandstone_slab',
                'minecraft:purpur_slab',
                'minecraft:prismarine_slab',
                'minecraft:prismarine_brick_slab',
                'minecraft:dark_prismarine_slab',
                'minecraft:smooth_quartz_slab',
                'minecraft:smooth_red_sandstone_slab',
                'minecraft:smooth_sandstone_slab',
                'minecraft:end_stone_brick_slab',
                'minecraft:andesite_slab',
                'minecraft:polished_andesite_slab',
                'minecraft:diorite_slab',
                'minecraft:polished_diorite_slab',
                'minecraft:granite_slab',
                'minecraft:polished_granite_slab',
                'minecraft:mossy_stone_brick_slab',
                'minecraft:mossy_cobblestone_slab',
                'minecraft:red_nether_brick_slab',
                'minecraft:blackstone_slab',
                'minecraft:polished_blackstone_slab',
                'minecraft:polished_blackstone_brick_slab',
                'minecraft:deepslate_slab',
                'minecraft:cobbled_deepslate_slab',
                'minecraft:polished_deepslate_slab',
                'minecraft:deepslate_brick_slab',
                'minecraft:deepslate_tile_slab',
                'minecraft:cut_copper_slab',
                'minecraft:exposed_cut_copper_slab',
                'minecraft:weathered_cut_copper_slab',
                'minecraft:oxidized_cut_copper_slab',
                'minecraft:waxed_cut_copper_slab',
                'minecraft:waxed_exposed_cut_copper_slab',
                'minecraft:waxed_weathered_cut_copper_slab',
                'minecraft:waxed_oxidized_cut_copper_slab',
                'minecraft:pot',
                'minecraft:decorated_pot',
                'minecraft:item_frame',
                'minecraft:glow_item_frame',
                'minecraft:button',
                'minecraft:acacia_button',
                'minecraft:birch_button',
                'minecraft:dark_oak_button',
                'minecraft:jungle_button',
                'minecraft:oak_button',
                'minecraft:spruce_button',
                'minecraft:stone_button',
                'minecraft:pressure_plate',
                'minecraft:acacia_pressure_plate',
                'minecraft:birch_pressure_plate',
                'minecraft:dark_oak_pressure_plate',
                'minecraft:heavy_weighted_pressure_plate',
                'minecraft:jungle_pressure_plate',
                'minecraft:light_weighted_pressure_plate',
                'minecraft:oak_pressure_plate',
                'minecraft:spruce_pressure_plate',
                'minecraft:stone_pressure_plate',
                'minecraft:rail',
                'minecraft:detector_rail',
                'minecraft:activator_rail',
                'minecraft:powered_rail'
            ]
            const northConnects = !excludeBlocksArray.includes(north?.typeId)
            const eastConnects = !excludeBlocksArray.includes(east?.typeId)
            const southConnects = !excludeBlocksArray.includes(south?.typeId)
            const westConnects = !excludeBlocksArray.includes(west?.typeId)
            block.setPermutation(block.permutation.withState('v360:north_picket', northConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:south_picket', southConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:east_picket', eastConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:west_picket', westConnects ? 1 : 0))
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:end_fence_tick', {
        onTick(e) {
            const { block } = e
            const aboveBlock = block.above()
            if (block.typeId === 'v360:end_fence_block' && aboveBlock.typeId === 'minecraft:air') {
                block.setType('v360:end_fence')
            }
            const north = block.north()
            const east = block.east()
            const south = block.south()
            const west = block.west()
            const excludeBlocksArray = [
                'minecraft:air',
                block.hasTag('plant'),
                'minecraft:ladder',
                'minecraft:cobweb',
                'minecraft:tripwire_hook',
                'minecraft:sea_pickle',
                'minecraft:dead_bush',
                'minecraft:yellow_flower',
                'minecraft:poppy',
                'minecraft:blue_orchid',
                'minecraft:allium',
                'minecraft:azure_bluet',
                'minecraft:oxeye_daisy',
                'minecraft:sunflower',
                'minecraft:lilac',
                'minecraft:rose_bush',
                'minecraft:peony',
                'minecraft:brown_mushroom',
                'minecraft:red_mushroom',
                'minecraft:hanging_roots',
                'minecraft:glow_lichen',
                'minecraft:azalia',
                'minecraft:flowering_azalea',
                'minecraft:big_dripleaf',
                'minecraft:small_dripleaf_block',
                'minecraft:pointed_dripstone',
                'minecraft:reeds',
                'minecraft:coral',
                'minecraft:coral_fan',
                'minecraft:spore_blossom',
                'minecraft:vines',
                'minecraft:weeping_vines',
                'minecraft:twisting_vines',
                'minecraft:sweet_berry_bush',
                'minecraft:carrots',
                'minecraft:potatoes',
                'minecraft:beetroot',
                'minecraft:wheat',
                'minecraft:pumpkin_stem',
                'minecraft:melon_stem',
                'minecraft:bamboo',
                'minecraft:bamboo_sapling',
                'minecraft:moss_carpet',
                'v360:infected_moss_carpet',
                'minecraft:nether_wart',
                'minecraft:waterlily',
                'minecraft:cocoa',
                'minecraft:redstone_wire',
                'minecraft:frog_spawn',
                'minecraft:chorus_flower',
                'minecraft:chorus_plant',
                'minecraft:scaffolding',
                'minecraft:torchflower',
                'minecraft:torflower_crop',
                'minecraft:unlit_redstone_torch',
                'minecraft:pitcher_plant',
                'minecraft:pitcher_crop',
                'minecraft:farmland',
                'minecraft:grass_path',
                'minecraft:nether_sprouts',
                'minecraft:crimson_roots',
                'minecraft:acacia_leaves',
                'minecraft:azalea_leaves',
                'minecraft:birch_leaves',
                'minecraft:cherry_leaves',
                'minecraft:dark_oak_leaves',
                'minecraft:flowering_azalea_leaves',
                'minecraft:jungle_leaves',
                'minecraft:mangrove_leaves',
                'minecraft:oak_leaves',
                'minecraft:spruce_leaves',
                'minecraft:orange_carpet',
                'minecraft:magenta_carpet',
                'minecraft:light_blue_carpet',
                'minecraft:yellow_carpet',
                'minecraft:lime_carpet',
                'minecraft:pink_carpet',
                'minecraft:gray_carpet',
                'minecraft:light_gray_carpet',
                'minecraft:cyan_carpet',
                'minecraft:purple_carpet',
                'minecraft:blue_carpet',
                'minecraft:brown_carpet',
                'minecraft:green_carpet',
                'minecraft:red_carpet',
                'minecraft:black_carpet',
                'minecraft:observer',
                'minecraft:amethyst_cluster',
                'minecraft:acacia_door',
                'minecraft:birch_door',
                'minecraft:dark_oak_door',
                'minecraft:iron_door',
                'minecraft:jungle_door',
                'minecraft:oak_door',
                'minecraft:spruce_door',
                'minecraft:bamboo_door',
                'minecraft:cherry_door',
                'minecraft:copper_door',
                'minecraft:exposed_copper_door',
                'minecraft:weathered_copper_door',
                'minecraft:oxidized_copper_door',
                'minecraft:waxed_copper_door',
                'minecraft:waxed_exposed_copper_door',
                'minecraft:waxed_weathered_copper_door',
                'minecraft:waxed_oxidized_copper_door',
                'minecraft:torch',
                'minecraft:soul_torch',
                'minecraft:lantern',
                'minecraft:soul_lantern',
                'minecraft:acacia_sign',
                'minecraft:birch_sign',
                'minecraft:dark_oak_sign',
                'minecraft:jungle_sign',
                'minecraft:oak_sign',
                'minecraft:spruce_sign',
                'minecraft:mangrove_sign',
                'minecraft:crimson_sign',
                'minecraft:warped_sign',
                'minecraft:bamboo_sign',
                'minecraft:cherry_sign',
                'minecraft:acacia_wall_sign',
                'minecraft:birch_wall_sign',
                'minecraft:dark_oak_wall_sign',
                'minecraft:jungle_wall_sign',
                'minecraft:oak_wall_sign',
                'minecraft:spruce_wall_sign',
                'minecraft:mangrove_wall_sign',
                'minecraft:crimson_wall_sign',
                'minecraft:warped_wall_sign',
                'minecraft:bamboo_wall_sign',
                'minecraft:cherry_wall_sign',
                'minecraft:oak_hanging_sign',
                'minecraft:spruce_hanging_sign',
                'minecraft:birch_hanging_sign',
                'minecraft:jungle_hanging_sign',
                'minecraft:acacia_hanging_sign',
                'minecraft:dark_oak_hanging_sign',
                'minecraft:mangrove_hanging_sign',
                'minecraft:crimson_hanging_sign',
                'minecraft:warped_hanging_sign',
                'minecraft:bamboo_hanging_sign',
                'minecraft:cherry_hanging_sign',
                'minecraft:glass_pane',
                'minecraft:iron_bars',
                'minecraft:barrel',
                'minecraft:chest',
                'minecraft:ender_chest',
                'minecraft:trapped_chest',
                'minecraft:dragon_egg',
                'minecraft:white_banner',
                'minecraft:orange_banner',
                'minecraft:magenta_banner',
                'minecraft:light_blue_banner',
                'minecraft:yellow_banner',
                'minecraft:lime_banner',
                'minecraft:pink_banner',
                'minecraft:gray_banner',
                'minecraft:light_gray_banner',
                'minecraft:cyan_banner',
                'minecraft:purple_banner',
                'minecraft:blue_banner',
                'minecraft:brown_banner',
                'minecraft:green_banner',
                'minecraft:red_banner',
                'minecraft:black_banner',
                'minecraft:acacia_trapdoor',
                'minecraft:birch_trapdoor',
                'minecraft:dark_oak_trapdoor',
                'minecraft:iron_trapdoor',
                'minecraft:jungle_trapdoor',
                'minecraft:oak_trapdoor',
                'minecraft:spruce_trapdoor',
                'minecraft:acacia_trapdoor',
                'minecraft:bamboo_trapdoor',
                'minecraft:cherry_trapaoor',
                'minecraft:copper_trapdoor',
                'minecraft:exposed_copper_trapdoor',
                'minecraft:weathered_copper_trapdoor',
                'minecraft:oxidized_copper_trapdoor',
                'minecraft:waxed_copper_trapdoor',
                'minecraft:waxed_exposed_copper_trapdoor',
                'minecraft:waxed_weathered_copper_trapdoor',
                'minecraft:waxed_oxidized_copper_trapdoor',
                'minecraft:cobblestone_wall',
                'minecraft:mossy_cobblestone_wall',
                'minecraft:brick_wall',
                'minecraft:prismarine_wall',
                'minecraft:red_sandstone_wall',
                'minecraft:mossy_stone_brick_wall',
                'minecraft:granite_wall',
                'minecraft:stone_brick_wall',
                'minecraft:nether_brick_wall',
                'minecraft:andesite_wall',
                'minecraft:red_nether_brick_wall',
                'minecraft:sandstone_wall',
                'minecraft:end_stone_brick_wall',
                'minecraft:diorite_wall',
                'minecraft:blackstone_wall',
                'minecraft:polished_blackstone_wall',
                'minecraft:polished_blackstone_brick_wall',
                'minecraft:copper_wall',
                'minecraft:bed',
                'minecraft:white_bed',
                'minecraft:orange_bed',
                'minecraft:magenta_bed',
                'minecraft:light_blue_bed',
                'minecraft:yellow_bed',
                'minecraft:lime_bed',
                'minecraft:pink_bed',
                'minecraft:gray_bed',
                'minecraft:light_gray_bed',
                'minecraft:cyan_bed',
                'minecraft:purple_bed',
                'minecraft:blue_bed',
                'minecraft:brown_bed',
                'minecraft:green_bed',
                'minecraft:red_bed',
                'minecraft:black_bed',
                'minecraft:candle',
                'minecraft:white_candle',
                'minecraft:orange_candle',
                'minecraft:magenta_candle',
                'minecraft:light_blue_candle',
                'minecraft:yellow_candle',
                'minecraft:lime_candle',
                'minecraft:pink_candle',
                'minecraft:gray_candle',
                'minecraft:light_gray_candle',
                'minecraft:cyan_candle',
                'minecraft:purple_candle',
                'minecraft:blue_candle',
                'minecraft:brown_candle',
                'minecraft:green_candle',
                'minecraft:red_candle',
                'minecraft:black_candle',
                'minecraft:campfire',
                'minecraft:soul_campfire',
                'minecraft:anvil',
                'minecraft:chipped_anvil',
                'minecraft:damaged_anvil',
                'minecraft:coral_fan',
                'minecraft:dead_coral_fan',
                'minecraft:fire_coral_fan',
                'minecraft:horn_coral_fan',
                'minecraft:bubble_coral_fan',
                'minecraft:tube_coral_fan',
                'minecraft:brain_coral_fan',
                'minecraft:acacia_sapling',
                'minecraft:birch_sapling',
                'minecraft:dark_oak_sapling',
                'minecraft:jungle_sapling',
                'minecraft:oak_sapling',
                'minecraft:spruce_sapling',
                'minecraft:red_tulip',
                'minecraft:orange_tulip',
                'minecraft:white_tulip',
                'minecraft:pink_tulip',
                'minecraft:acacia_slab',
                'minecraft:birch_slab',
                'minecraft:dark_oak_slab',
                'minecraft:jungle_slab',
                'minecraft:oak_slab',
                'minecraft:spruce_slab',
                'minecraft:mangrove_slab',
                'minecraft:crimson_slab',
                'minecraft:warped_slab',
                'minecraft:bamboo_slab',
                'minecraft:cherry_slab',
                'minecraft:stone_slab',
                'minecraft:smooth_stone_slab',
                'minecraft:sandstone_slab',
                'minecraft:cut_sandstone_slab',
                'minecraft:petrified_oak_slab',
                'minecraft:cobblestone_slab',
                'minecraft:brick_slab',
                'minecraft:stone_brick_slab',
                'minecraft:nether_brick_slab',
                'minecraft:quartz_slab',
                'minecraft:red_sandstone_slab',
                'minecraft:cut_red_sandstone_slab',
                'minecraft:purpur_slab',
                'minecraft:prismarine_slab',
                'minecraft:prismarine_brick_slab',
                'minecraft:dark_prismarine_slab',
                'minecraft:smooth_quartz_slab',
                'minecraft:smooth_red_sandstone_slab',
                'minecraft:smooth_sandstone_slab',
                'minecraft:end_stone_brick_slab',
                'minecraft:andesite_slab',
                'minecraft:polished_andesite_slab',
                'minecraft:diorite_slab',
                'minecraft:polished_diorite_slab',
                'minecraft:granite_slab',
                'minecraft:polished_granite_slab',
                'minecraft:mossy_stone_brick_slab',
                'minecraft:mossy_cobblestone_slab',
                'minecraft:red_nether_brick_slab',
                'minecraft:blackstone_slab',
                'minecraft:polished_blackstone_slab',
                'minecraft:polished_blackstone_brick_slab',
                'minecraft:deepslate_slab',
                'minecraft:cobbled_deepslate_slab',
                'minecraft:polished_deepslate_slab',
                'minecraft:deepslate_brick_slab',
                'minecraft:deepslate_tile_slab',
                'minecraft:cut_copper_slab',
                'minecraft:exposed_cut_copper_slab',
                'minecraft:weathered_cut_copper_slab',
                'minecraft:oxidized_cut_copper_slab',
                'minecraft:waxed_cut_copper_slab',
                'minecraft:waxed_exposed_cut_copper_slab',
                'minecraft:waxed_weathered_cut_copper_slab',
                'minecraft:waxed_oxidized_cut_copper_slab',
                'minecraft:pot',
                'minecraft:decorated_pot',
                'minecraft:item_frame',
                'minecraft:glow_item_frame',
                'minecraft:button',
                'minecraft:acacia_button',
                'minecraft:birch_button',
                'minecraft:dark_oak_button',
                'minecraft:jungle_button',
                'minecraft:oak_button',
                'minecraft:spruce_button',
                'minecraft:stone_button',
                'minecraft:pressure_plate',
                'minecraft:acacia_pressure_plate',
                'minecraft:birch_pressure_plate',
                'minecraft:dark_oak_pressure_plate',
                'minecraft:heavy_weighted_pressure_plate',
                'minecraft:jungle_pressure_plate',
                'minecraft:light_weighted_pressure_plate',
                'minecraft:oak_pressure_plate',
                'minecraft:spruce_pressure_plate',
                'minecraft:stone_pressure_plate',
                'minecraft:rail',
                'minecraft:detector_rail',
                'minecraft:activator_rail',
                'minecraft:powered_rail'
            ]
            const northConnects = !excludeBlocksArray.includes(north?.typeId)
            const eastConnects = !excludeBlocksArray.includes(east?.typeId)
            const southConnects = !excludeBlocksArray.includes(south?.typeId)
            const westConnects = !excludeBlocksArray.includes(west?.typeId)
            block.setPermutation(block.permutation.withState('v360:north_picket', northConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:south_picket', southConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:east_picket', eastConnects ? 1 : 0))
            block.setPermutation(block.permutation.withState('v360:west_picket', westConnects ? 1 : 0))
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:end_fence_place', {
        onPlace(e) {
            const { block } = e
            const aboveBlock = block.above()
            e.block.setType('v360:end_fence_block')
            if (aboveBlock.typeId === 'minecraft:air') {
                aboveBlock.setPermutation(BlockPermutation.resolve('v360:end_fence', { 'v360:post': 1 }))
            }
        }
    })
})
